#include "operatingsystem.h"
#include "c4d_memory.h"
#include "c4d_baseselect.h"
#include "c4d_file.h"



BaseSelect *BaseSelect::Alloc(void)
{
	return C4DOS.Bs->Alloc();
}

void BaseSelect::Free(BaseSelect *&bs)
{
	C4DOS.Bs->Free(bs);
	bs=NULL;
}

void BaseSelect::FlushAll(void)
{
	C4DOS.Bs->FlushAll(this);
}

LONG BaseSelect::GetCount(void)
{
	return C4DOS.Bs->GetCount(this);
}

LONG BaseSelect::GetSegments(void)
{
	return C4DOS.Bs->GetSegments(this);
}

Bool BaseSelect::Select(LONG num)
{
	return C4DOS.Bs->Select(this,num);
}

Bool BaseSelect::SelectAll(LONG min, LONG max)
{
	return C4DOS.Bs->SelectAll(this,min,max);
}

Bool BaseSelect::Deselect(LONG num)
{
	return C4DOS.Bs->Deselect(this,num);
}

Bool BaseSelect::DeselectAll(void)
{
	return C4DOS.Bs->DeselectAll(this);
}

Bool BaseSelect::Toggle(LONG num)
{
	return C4DOS.Bs->Toggle(this,num);
}

Bool BaseSelect::ToggleAll(LONG min, LONG max)
{
	return C4DOS.Bs->ToggleAll(this,min,max);
}

Bool BaseSelect::GetRange(LONG seg, LONG *a, LONG *b)
{
	return C4DOS.Bs->GetRange(this,seg,a,b);
}

Bool BaseSelect::CopyTo(BaseSelect *dest)
{
	return C4DOS.Bs->CopyTo(this,dest);
}

BaseSelect *BaseSelect::GetClone(void)
{
	return C4DOS.Bs->GetClone(this);
}

Bool BaseSelect::FromArray(UCHAR *selection, LONG count)
{
	return C4DOS.Bs->FromArray(this,selection,count);
}

UCHAR *BaseSelect::ToArray(LONG count)
{
	return C4DOS.Bs->ToArray(this,count);
}

void BaseSelect::Write(HyperFile *hf)
{
	// level
	hf->WriteLong(0);

	LONG i,a,b;
	LONG cnt = GetSegments();
	hf->WriteLong(cnt);
	for (i=0; i<cnt; i++)
	{
		GetRange(i,&a,&b);
		hf->WriteLong(a);
		hf->WriteLong(b);
	}
}

Bool BaseSelect::Read(HyperFile *hf)
{
	LONG level;

	hf->ReadLong(&level);

	if (level>=0)
	{
		DeselectAll();

		LONG i,cnt,a,b;
		hf->ReadLong(&cnt);
		if (cnt)
		{
			for (i=0; i<cnt; i++)
			{
				hf->ReadLong(&a);
				hf->ReadLong(&b);
				for (;a<=b;a++)
				{
					Select(a);
				}
			}
		}
	}
	return TRUE;
}
